DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `product_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `admin_id` INT unsigned NOT NULL,
  `model` varchar(64) NOT NULL DEFAULT '',
  `sku` varchar(64) NOT NULL DEFAULT '',
  `upc` varchar(12) NOT NULL DEFAULT '',
  `ean` varchar(14) NOT NULL DEFAULT '',
  `jan` varchar(13) NOT NULL DEFAULT '',
  `isbn` varchar(17) NOT NULL DEFAULT '',
  `mpn` varchar(64) NOT NULL DEFAULT '',
  `barcode` varchar(64) NOT NULL DEFAULT '',
  `hs_code` varchar(10) NOT NULL DEFAULT '',
  `origin_country` varchar(64) NOT NULL DEFAULT '',
  `mid_code` varchar(13) NOT NULL DEFAULT '',
  `location` varchar(128) NOT NULL DEFAULT '',
  `stock_quantity` int(4) NOT NULL DEFAULT 1,
  `stock_status_id` INT UNSIGNED NOT NULL DEFAULT 1,
  `image` varchar(191) NOT NULL DEFAULT '',
  `manufacturer_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `vendor_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `requires_shipping` tinyint NOT NULL DEFAULT 1,
  `old_price` decimal(15,4) NOT NULL DEFAULT 0.0000,
  `price` decimal(15,4) NOT NULL DEFAULT 0.0000,
  `points` int(8) NOT NULL DEFAULT 0,
  `tax_type_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `material` varchar(64) NOT NULL DEFAULT '',
  `weight` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `weight_type_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `length` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `width` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `height` decimal(15,8) NOT NULL DEFAULT '0.00000000',
  `length_type_id` INT UNSIGNED NOT NULL DEFAULT 0,
  `date_available` date,
  `type` varchar(20) NOT NULL DEFAULT 'product',
  `template` varchar(191) NOT NULL DEFAULT '',
  `views` INT(5)  unsigned NOT NULL DEFAULT 0,
  `subtract_stock` tinyint NOT NULL DEFAULT 1,
  `minimum_quantity` INT UNSIGNED NOT NULL DEFAULT 1,
  `subscription_onetime` tinyint UNSIGNED NOT NULL DEFAULT 1,
  `status` tinyint NOT NULL DEFAULT 0,
  `sort_order` INT UNSIGNED NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_id`),
  KEY `type_status_date` (`type`,`status`,`created_at`,`product_id`),
  KEY `stock_status_id` (`stock_status_id`),
  KEY `vendor_id` (`vendor_id`),
  KEY `manufacturer_id` (`stock_status_id`),
  KEY `barcode` (`barcode`),
  KEY `sku` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

